/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools.content.spawner;

import dev.ftb.ftbsbc.tools.ToolsRegistry;
import dev.ftb.ftbsbc.tools.integration.kubejs.data.SpawnerDataKjs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class BitsSpawnerBlockEntity
extends BlockEntity {
    private static final EntityTypeTest<Entity, Mob> MOB_TEST = EntityTypeTest.m_156916_(Mob.class);
    private short spawnDelay = (short)20;
    private short minDelay = (short)50;
    private short maxDelay = (short)300;
    private short spawnRange = (short)5;
    public double spin;
    public double oSpin;
    private final int requiredPlayerRange = 16;
    private final Random random = new Random();
    private Entity displayEntity;

    public BitsSpawnerBlockEntity(BlockPos arg2, BlockState arg3) {
        super((BlockEntityType)ToolsRegistry.BITS_BLOCK_ENTITY.get(), arg2, arg3);
    }

    private boolean isNearPlayer(Level arg, BlockPos arg2) {
        return arg.m_45914_((double)arg2.m_123341_() + 0.5, (double)arg2.m_123342_() + 0.5, (double)arg2.m_123343_() + 0.5, (double)this.requiredPlayerRange);
    }

    public void clientTick(Level arg, BlockPos arg2) {
        if (!this.isNearPlayer(arg, arg2)) {
            this.oSpin = this.spin;
        } else {
            double d0 = (double)arg2.m_123341_() + arg.f_46441_.nextDouble();
            double d1 = (double)arg2.m_123342_() + arg.f_46441_.nextDouble();
            double d2 = (double)arg2.m_123343_() + arg.f_46441_.nextDouble();
            arg.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            arg.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
            arg.m_7106_((ParticleOptions)ParticleTypes.f_123809_, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                this.spawnDelay = (short)(this.spawnDelay - 1);
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    private void serverTick(ServerLevel level, BlockPos pos) {
        if (!this.isNearPlayer((Level)level, pos)) {
            return;
        }
        if (this.spawnDelay > 0) {
            this.spawnDelay = (short)(this.spawnDelay - 1);
            return;
        }
        if (level.m_45517_(LightLayer.BLOCK, pos) >= 13) {
            this.spawnDelay = this.delay();
            return;
        }
        for (int i = 0; i < Math.max(SpawnerDataKjs.minSpawnAmount, this.random.nextInt(SpawnerDataKjs.maxSpawnAmount)); ++i) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            boolean validLocationFound = false;
            for (int a = 0; a < 5; ++a) {
                x = pos.m_123341_() + this.random.nextInt(this.spawnRange) * ((double)this.random.nextFloat() > 0.5 ? -1 : 1);
                BlockPos blockPos = new BlockPos(x, y = pos.m_123342_() + 1, z = pos.m_123343_() + this.random.nextInt(this.spawnRange) * ((double)this.random.nextFloat() > 0.5 ? -1 : 1));
                if (!level.m_8055_(blockPos).m_60795_() || !level.m_8055_(blockPos.m_7494_()).m_60795_()) continue;
                validLocationFound = true;
                break;
            }
            if (!validLocationFound) continue;
            CompoundTag compound = new CompoundTag();
            List<SpawnerDataKjs.SpawnableEntity> validMobsForBiome = this.getValidMobsForBiome();
            if (validMobsForBiome.size() == 0) {
                this.spawnDelay = this.delay();
                return;
            }
            SpawnerDataKjs.SpawnableEntity entityId = validMobsForBiome.get(this.random.nextInt(validMobsForBiome.size()));
            compound.m_128359_("id", entityId.entityId().toString());
            int tmpX = x;
            int tmpY = y;
            int tmpZ = z;
            Entity entity = EntityType.m_20645_((CompoundTag)compound, (Level)level, e -> {
                e.m_6027_((double)tmpX, (double)tmpY, (double)tmpZ);
                return e;
            });
            if (entity == null) {
                this.spawnDelay = this.delay();
                return;
            }
            AABB aabb = new AABB(new BlockPos(x, y, z)).m_82400_((double)(this.spawnRange + 5));
            if (level.m_142425_(MOB_TEST, aabb, Entity::m_6084_).size() >= 20) {
                this.spawnDelay = this.delay();
                return;
            }
            entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                ((Mob)entity).m_6518_((ServerLevelAccessor)level, level.m_6436_(entity.m_142538_()), MobSpawnType.SPAWNER, null, null);
            }
            if (!level.m_8860_(entity)) {
                this.spawnDelay = this.delay();
                return;
            }
            level.m_46796_(2004, pos, 0);
            if (!(entity instanceof Mob)) continue;
            ((Mob)entity).m_21373_();
        }
        this.spawnDelay = this.delay();
    }

    private List<SpawnerDataKjs.SpawnableEntity> getValidMobsForBiome() {
        if (this.f_58857_ == null) {
            return new ArrayList<SpawnerDataKjs.SpawnableEntity>();
        }
        Holder biome = this.f_58857_.m_204166_(this.m_58899_());
        return SpawnerDataKjs.entitiesToSpawn.stream().filter(e -> e.allowedBiome() == null || biome.m_203656_(e.allowedBiome())).toList();
    }

    private short delay() {
        return (short)(this.maxDelay <= this.minDelay ? this.minDelay : this.minDelay + this.random.nextInt(this.maxDelay - this.minDelay));
    }

    public static void clientTick(Level arg, BlockPos arg2, BlockState arg3, BitsSpawnerBlockEntity blockEntity) {
        blockEntity.clientTick(arg, arg2);
    }

    public static void serverTick(Level arg, BlockPos arg2, BlockState arg3, BitsSpawnerBlockEntity blockEntity) {
        blockEntity.serverTick((ServerLevel)arg, arg2);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag arg) {
        super.m_142466_(arg);
        this.spawnDelay = arg.m_128448_("spawnDelay");
        this.minDelay = arg.m_128448_("minDelay");
        this.maxDelay = arg.m_128448_("maxDelay");
        this.spawnRange = arg.m_128448_("spawnRange");
    }

    protected void m_183515_(CompoundTag arg) {
        super.m_183515_(arg);
        arg.m_128376_("spawnDelay", this.spawnDelay);
        arg.m_128376_("minDelay", this.minDelay);
        arg.m_128376_("maxDelay", this.maxDelay);
        arg.m_128376_("spawnRange", this.spawnRange);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_6326_() {
        return true;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity() {
        if (this.displayEntity == null) {
            this.displayEntity = EntityType.f_20496_.m_20615_(this.f_58857_);
        }
        return this.displayEntity;
    }
}

